import http.server
import socketserver
import socket
import argparse
import logging
import threading
import time

# Configuration des arguments de ligne de commande
parser = argparse.ArgumentParser()

parser.add_argument(
    '--bind',
    help='Définir l\'interface serveur à lier (par défaut 0.0.0.0)')

parser.add_argument(
    '--outport',
    help='Définir la base du port sortant (par défaut 10000)')

parser.add_argument(
    '--port',
    help='Définir le port HTTP à lier (par défaut 8081)')

# Analyser les arguments de ligne de commande
args = parser.parse_args()
# Définir les valeurs des arguments ou utiliser les valeurs par défaut
HOST = (args.bind if args.bind else '0.0.0.0')
OUTPORT = (int(args.outport) if args.outport else 10000)
PORT = (int(args.port) if args.port else 8081)

# Dictionnaires pour stocker les connexions et les sockets
connections = dict()
sockets = dict()

# Fonction de ping pour maintenir la connexion active
def keep_alive(conn_id, conn):
    while True:
        try:
            conn.send(b'PING\r\n')
            time.sleep(5)  # Intervalle de 5 secondes pour les pings
        except:
            logging.info('Connection lost on port ' + str(conn_id) + ', closing.')
            conn.close()
            connections.pop(conn_id, None)
            break

# Classe pour gérer les requêtes HTTP
class NMEAHandler(http.server.BaseHTTPRequestHandler):
    # Gérer les requêtes POST
    def do_POST(s):
        content_len = int(s.headers.get('Content-Length'))
        post_body = s.rfile.read(content_len)
        race_id = s.path[6:9]
        forward_message(int(race_id), post_body)
        logging.info('Message retransmis: ' + post_body.decode('ascii'))
        s.send_response(204)
        s.send_header('Access-Control-Allow-Origin', '*')
        s.end_headers()

    # Supprimer les messages de journalisation inutiles
    def log_message(self, format, *args):
        pass

# Transmettre le message à la connexion appropriée
def forward_message(conn_id, message):
    conn = find_or_create_connection(conn_id)
    if conn:
        try:
            conn.send(message + '\r\n'.encode('ascii'))
        except Exception:
            logging.info('Connection lost on port ' + str(conn_id)
                         + ', closing.')
            conn.close()
            connections.pop(conn_id, None)

# Trouver ou créer une connexion pour l'ID de connexion donné
def find_or_create_connection(conn_id):
    if conn_id in connections:
        return connections[conn_id]
    else:
        conn = None
        if conn_id not in sockets:
            sockets[conn_id] = create_socket(conn_id)
        conn = accept_connection(sockets[conn_id])
        if conn:
            connections[conn_id] = conn
            # Démarrer un thread de "keep-alive" pour cette connexion
            threading.Thread(target=keep_alive, args=(conn_id, conn), daemon=True).start()
        return conn

# Créer une socket pour l'ID de course donné
def create_socket(conn_id):
    logging.info('Creating socket for race ID ' + str(conn_id))
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    sock.setblocking(False)
    sock.bind((HOST, OUTPORT + conn_id))
    sock.listen(0)
    return sock

# Accepter une connexion entrante sur la socket
def accept_connection(sock):
    try:
        (conn, address) = sock.accept()
        logging.info('Accepted connection on port '
                     + str(sock.getsockname()[1]))
        return conn
    except IOError:
        return None

# Configurer la journalisation
logging.basicConfig(level=logging.INFO)

logging.info("Creating Server")
# Créer le serveur HTTP
server = socketserver.TCPServer(("", PORT), NMEAHandler)
logging.info("httpd listening on port " + str(PORT))

try:
    # Démarrer le serveur
    server.serve_forever()
except KeyboardInterrupt:
    pass
finally:
    # Nettoyer et fermer le serveur
    logging.info('Cleaning up')
    server.server_close()
    logging.info('Stopping httpd\n')
